
#ifdef _WIN32
#define GLM_FORCE_RADIANS
#endif

#define SDW_OPENGL
#include "qdw.hpp"
#include <iostream>
#include "glow.hpp"
#include "scene.h"

qdw::TexGui make_title_menu(const sdw::Renderer &ren, const qdw::Theme &theme, SDL_Rect area);

#include <glm/glm.hpp>
#include <glm/gtc/matrix_transform.hpp>
#include <glm/gtx/transform.hpp>

/*struct VertexC {
    float x,y,z;
    float r,g,b,a;
};*/
struct FogData {float density; glm::vec4 color;};
struct GL_Handles {
    std::shared_ptr<glow::Geometry<VertexC,GLshort>> geo;
    std::shared_ptr<glow::Shader> shader;
};
GL_Handles init_gl_stuff();
void draw_gl_stuff(GL_Handles &handles);
glm::mat4 camera();

int main(int argc, char **argv)
try {

    sdw::Context c(SDL_INIT_EVERYTHING,IMG_INIT_ALL,true);

    sdw::GL_Attributes gla;
    #ifdef USE_SHADER
    gla[SDL_GL_CONTEXT_MAJOR_VERSION]=3;
    gla[SDL_GL_CONTEXT_MINOR_VERSION]=3;
    gla[SDL_GL_CONTEXT_PROFILE_MASK]=SDL_GL_CONTEXT_PROFILE_COMPATIBILITY;
    gla[SDL_GL_MULTISAMPLEBUFFERS]=1;
    gla[SDL_GL_MULTISAMPLESAMPLES]=4;
    #else
    gla[SDL_GL_CONTEXT_MAJOR_VERSION]=1;
    gla[SDL_GL_CONTEXT_MINOR_VERSION]=4;
    #endif
    sdw::GL_Window win("SDL-Test",100,100,640,480,gla);

    sdw::Font arial18("arial.ttf",18);
    sdw::Renderer ren(win,SDL_RENDERER_ACCELERATED); // I don't want vsync here (to test performance limits)

    GL_Handles glh = init_gl_stuff();

    qdw::Theme btn_theme(sdw::Surface("tileset_windows.png"),sdw::Font("arial.ttf",12),16,2);
    qdw::TexGui main_gui = make_title_menu(ren,btn_theme,sdw::Rect(win.width()/2-200,0,400,win.height()));
    main_gui.get("btn_settings")->disable();
    bool quit=false; main_gui.get("btn_quit")->mouseClick=[&](qdw::Widget*,const SDL_Event&) {quit=true;};
    bool demo=false; main_gui.get("btn_demo")->mouseClick=[&](qdw::Widget*,const SDL_Event&) {demo=true;};

    int lastframe = SDL_GetTicks();
    int updated_frm = 0;
    int total_frm = 0;
    std::stringstream temp;

    //Our event structure
    SDL_Event e;

    while (!quit) {
        while (SDL_PollEvent(&e)){
            if (!main_gui.hit(e)) { // Only process events the GUI didn't consume
                if (e.type == SDL_QUIT)
                    quit = true;
                if (e.type == SDL_KEYDOWN){
                    switch (e.key.keysym.sym){
                        case SDLK_ESCAPE:
                            quit = true;
                            break;
                        default:
                            break;
                    }
                }
            }
        }

        if (demo) {
            Scene testscene;
            testscene.run(win,ren);
            demo = false;
        }

        // Update Widgets (if necessary)
        if (main_gui.update()) updated_frm++;
        total_frm++;

        // Performance indicators
        int t = SDL_GetTicks();
        temp.str(""); temp.clear();
        temp<<t-lastframe<<" ms/frm";
        sdw::Surface tpf = arial18.write_solid(temp.str(),sdw::Color(255,0,0));
        lastframe = t;

        win.fill(0,0,0);
        draw_gl_stuff(glh);
        main_gui.texture.gl_render(sdw::Rect(win.width()/2-200,0,400,win.height()));
        sdw::Texture ttpf(ren,tpf); ttpf.gl_render(sdw::Point(win.width()-tpf.width()-5,5));
        win.flip();
    }
    return 0;

} catch(sdw::Error e) {
    std::cerr<<"Error: "<<e<<std::endl;
    return 0;
} catch (...) {
    std::cerr<<"Unknown exception!"<<std::endl;
    return -1;
}

qdw::TexGui make_title_menu(const sdw::Renderer &ren, const qdw::Theme &theme, SDL_Rect area) {
    qdw::TexGui main_gui(ren,theme,area); // NRVO

    main_gui.addButton("btn_settings",sdw::Rect(area.w/2-140,area.h-50,80,24),"Settings",nullptr);
    main_gui.addButton("btn_quit",sdw::Rect(area.w/2-40,area.h-50,80,24),"Quit",nullptr);
    main_gui.addButton("btn_demo",sdw::Rect(area.w/2+60,area.h-50,80,24),"Test",nullptr);

    return main_gui;
}

GL_Handles init_gl_stuff() {
    GL_Handles handles;

    glEnable(GL_DEPTH_TEST);
    glDepthFunc(GL_LESS);
    glEnable(GL_CULL_FACE);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_TEXTURE_2D);

    glow::VertexDataInfos vdi;
    vdi.push_back(glow::VertexDataInfo(0,GL_VERTEX_ARRAY,3,GL_FLOAT,GL_FALSE,sizeof(VertexC),(void*)offsetof(VertexC,x)));
    vdi.push_back(glow::VertexDataInfo(1,GL_COLOR_ARRAY,4,GL_FLOAT,GL_FALSE,sizeof(VertexC),(void*)offsetof(VertexC,r)));
    handles.geo = std::make_shared<glow::Geometry<VertexC,GLshort>>(vdi);
    auto geom = handles.geo;

#ifdef USE_SHADER
    geom->make_buffers();
#endif

    geom->addTri( // X,Y,Z,               R, G, B, A
        {-1.0f,-1.0f,-1.0f,     0.583f,  0.771f,  0.014f, 1.f},
        {-1.0f,-1.0f, 1.0f,     0.609f,  0.115f,  0.436f, 1.f},
        {-1.0f, 1.0f, 1.0f,     0.327f,  0.483f,  0.844f, 1.f});
    geom->addTri(
        {1.0f, 1.0f,-1.0f,      0.822f,  0.569f,  0.201f, 1.f},
        {-1.0f,-1.0f,-1.0f,     0.435f,  0.602f,  0.223f, 1.f},
        {-1.0f, 1.0f,-1.0f,     0.310f,  0.747f,  0.185f, 1.f});
    geom->addTri(
        {1.0f,-1.0f, 1.0f,      0.597f,  0.770f,  0.761f, 1.f},
        {-1.0f,-1.0f,-1.0f,     0.559f,  0.436f,  0.730f, 1.f},
        {1.0f,-1.0f,-1.0f,      0.359f,  0.583f,  0.152f, 1.f});
    geom->addTri(
        {1.0f, 1.0f,-1.0f,      0.483f,  0.596f,  0.789f, 1.f},
        {1.0f,-1.0f,-1.0f,      0.559f,  0.861f,  0.639f, 1.f},
        {-1.0f,-1.0f,-1.0f,     0.195f,  0.548f,  0.859f, 1.f});
    geom->addTri(
        {-1.0f,-1.0f,-1.0f,     0.014f,  0.184f,  0.576f, 1.f},
        {-1.0f, 1.0f, 1.0f,     0.771f,  0.328f,  0.970f, 1.f},
        {-1.0f, 1.0f,-1.0f,     0.406f,  0.615f,  0.116f, 1.f});
    geom->addTri(
        {1.0f,-1.0f, 1.0f,      0.676f,  0.977f,  0.133f, 1.f},
        {-1.0f,-1.0f, 1.0f,     0.971f,  0.572f,  0.833f, 1.f},
        {-1.0f,-1.0f,-1.0f,     0.140f,  0.616f,  0.489f, 1.f});
    geom->addTri(
        {-1.0f, 1.0f, 1.0f,     0.997f,  0.513f,  0.064f, 1.f},
        {-1.0f,-1.0f, 1.0f,     0.945f,  0.719f,  0.592f, 1.f},
        {1.0f,-1.0f, 1.0f,      0.543f,  0.021f,  0.978f, 1.f});
    geom->addTri(
        {1.0f, 1.0f, 1.0f,      0.279f,  0.317f,  0.505f, 1.f},
        {1.0f,-1.0f,-1.0f,      0.167f,  0.620f,  0.077f, 1.f},
        {1.0f, 1.0f,-1.0f,      0.347f,  0.857f,  0.137f, 1.f});
    geom->addTri(
        {1.0f,-1.0f,-1.0f,      0.055f,  0.953f,  0.042f, 1.f},
        {1.0f, 1.0f, 1.0f,      0.714f,  0.505f,  0.345f, 1.f},
        {1.0f,-1.0f, 1.0f,      0.783f,  0.290f,  0.734f, 1.f});
    geom->addTri(
        {1.0f, 1.0f, 1.0f,      0.722f,  0.645f,  0.174f, 1.f},
        {1.0f, 1.0f,-1.0f,      0.302f,  0.455f,  0.848f, 1.f},
        {-1.0f, 1.0f,-1.0f,     0.225f,  0.587f,  0.040f, 1.f});
    geom->addTri(
        {1.0f, 1.0f, 1.0f,      0.517f,  0.713f,  0.338f, 1.f},
        {-1.0f, 1.0f,-1.0f,     0.053f,  0.959f,  0.120f, 1.f},
        {-1.0f, 1.0f, 1.0f,     0.393f,  0.621f,  0.362f, 1.f});
    geom->addTri(
        {1.0f, 1.0f, 1.0f,      0.673f,  0.211f,  0.457f, 1.f},
        {-1.0f, 1.0f, 1.0f,     0.820f,  0.883f,  0.371f, 1.f},
        {1.0f,-1.0f, 1.0f,      0.982f,  0.099f,  0.879f, 1.f});

    geom->addTriFan(std::vector<VertexC>({
        {3.f,0.f,2.f,           1.f,     0.f,     0.f,    1.f},
        {4.f,0.f,0.f,           1.f,     1.f,     0.f,    1.f},
        {3.5f,1.f,0.f,           1.f,     .67f,    .33f,   1.f},
        {2.5f,1.f,0.f,           1.f,     .33f,    .67f,   1.f},
        {2.f,0.f,0.f,           1.f,     0.f,     1.f,    1.f},
        {2.5f,-1.f,0.f,           1.f,     .33f,    .67f,   1.f},
        {3.f,-1.2f,0.f,           0.f,     0.f,    1.f,   1.f},
        {3.5f,-1.f,0.f,           1.f,     .67f,    .33f,   1.f}
        }));

    geom->addPoly(std::vector<VertexC>({
        {-2.f,0.f,0.f,           1.f,     1.f,     0.f,    1.f},
        {-2.5f,1.f,0.f,           1.f,     .67f,    .33f,   1.f},
        {-3.5f,1.f,0.f,           1.f,     .33f,    .67f,   1.f},
        {-4.f,0.f,0.f,           1.f,     0.f,     1.f,    1.f},
        {-3.5f,-1.f,0.f,           1.f,     .33f,    .67f,   1.f},
        {-3.f,-1.2f,0.f,           0.f,     0.f,    1.f,   1.f},
        {-2.5f,-1.f,0.f,           1.f,     .67f,    .33f,   1.f}
        }));

    geom->addTriStrip(std::vector<VertexC>({
        {6.f,1.f,1.f,           0.f,     1.f,     0.f,    1.f},
        {6.f,1.f,0.f,           1.f,     1.f,     0.f,    1.f},
        {5.5f,2.f,1.f,           0.f,     .67f,    .33f,   1.f},
        {5.5f,2.f,0.f,           1.f,     .67f,    .33f,   1.f},
        {4.5f,2.f,1.f,           0.f,     .33f,    .67f,   1.f},
        {4.5f,2.f,0.f,           1.f,     .33f,    .67f,   1.f},
        {4.f,1.f,1.f,           0.f,     0.f,     1.f,    1.f},
        {4.f,1.f,0.f,           1.f,     0.f,     1.f,    1.f},
        {4.5f,0.f,1.f,           0.f,     .33f,    .67f,   1.f},
        {4.5f,0.f,0.f,           1.f,     .33f,    .67f,   1.f},
        {5.5f,0.f,1.f,           0.f,     .67f,    .33f,   1.f},
        {5.5f,0.f,0.f,           1.f,     .67f,    .33f,   1.f},
        {6.f,1.f,1.f,           0.f,     1.f,     0.f,    1.f},
        {6.f,1.f,0.f,           1.f,     1.f,     0.f,    1.f}
        }));

    geom->addPoly(std::vector<VertexC>({
        {-2.f,-5.f,0.f,           1.f,     1.f,     0.f,    1.f},
        {-2.5f,-4.f,0.f,           1.f,     .67f,    .33f,   1.f},
        {-3.5f,-4.f,0.f,           1.f,     .33f,    .67f,   1.f},
        {-4.f,-5.f,0.f,           1.f,     0.f,     1.f,    1.f},
        {-3.5f,-6.f,0.f,           1.f,     .33f,    .67f,   1.f},
        {-2.5f,-6.f,0.f,           1.f,     .67f,    .33f,   1.f}
        }));

    geom->addQuad(
        {-4.0f, 1.0f, 1.0f,      1.f,  .25f,  .5f, 1.f},
        {-3.0f, 1.0f, 1.0f,     1.f,  1.f,  0.f, 1.f},
        {-3.0f,1.0f, 0.0f,      1.f,  0.f,  1.f, 1.f},
        {-4.0f, 1.0f, 0.0f,      0.f,  1.f,  1.f, 1.f});

    geom->addTriStrip(std::vector<VertexC>({
        {6.f,1.f,3.f,           0.f,     1.f,     0.f,    1.f},
        {6.f,1.f,2.f,           1.f,     1.f,     0.f,    1.f},
        {5.5f,2.f,3.f,           0.f,     .67f,    .33f,   1.f},
        {5.5f,2.f,2.f,           1.f,     .67f,    .33f,   1.f},
        {4.5f,2.f,3.f,           0.f,     .33f,    .67f,   1.f},
        {4.5f,2.f,2.f,           1.f,     .33f,    .67f,   1.f},
        {4.f,1.f,3.f,           0.f,     0.f,     1.f,    1.f},
        {4.f,1.f,2.f,           1.f,     0.f,     1.f,    1.f},
        {4.5f,0.f,3.f,           0.f,     .33f,    .67f,   1.f},
        {4.5f,0.f,2.f,           1.f,     .33f,    .67f,   1.f},
        {5.5f,0.f,3.f,           0.f,     .67f,    .33f,   1.f},
        {5.5f,0.f,2.f,           1.f,     .67f,    .33f,   1.f},
        {6.f,1.f,3.f,           0.f,     1.f,     0.f,    1.f},
        {6.f,1.f,2.f,           1.f,     1.f,     0.f,    1.f}
        }));

    geom->addTriFan(std::vector<VertexC>({
        {3.f,-5.f,4.f,           1.f,     0.f,     0.f,    1.f},
        {4.f,-5.f,0.f,           1.f,     1.f,     0.f,    1.f},
        {3.5f,-4.f,0.f,           1.f,     .67f,    .33f,   1.f},
        {2.5f,-4.f,0.f,           1.f,     .33f,    .67f,   1.f},
        {2.f,-5.f,0.f,           1.f,     0.f,     1.f,    1.f},
        {2.5f,-6.f,0.f,           1.f,     .33f,    .67f,   1.f},
        {3.5f,-6.f,0.f,           1.f,     .67f,    .33f,   1.f}
        }));

#ifdef USE_SHADER
    geom->upload();
    geom->clear_local();

    handles.shader = std::make_shared<glow::Shader>("persp_color.vs","simple_fog.fs");

    glow::UniformBlock<FogData> fog;
    fog.layout("density",offsetof(FogData,density),sizeof(float));
    fog.layout("fcol",offsetof(FogData,color),sizeof(glm::vec4));
    fog = FogData({0.01f,glm::vec4(0.f,0.f,0.f,1.f)});
    handles.shader->copy_uniform("fog",fog);

    glow::Uniform<glm::mat4> cam = glm::mat4(1.f);
    handles.shader->copy_uniform("MVP",cam);
#endif

    return handles;
}
void draw_gl_stuff(GL_Handles &handles) {
        glClear(GL_DEPTH_BUFFER_BIT);

        glEnable(GL_DEPTH_TEST);
        glEnable(GL_CULL_FACE);

#ifdef USE_SHADER
        handles.shader->uniform<glm::mat4>("MVP")=camera();
        float t = SDL_GetTicks()/1000.f;
        glm::vec4 fogcolor = glm::vec4(.25f+.25f*sin(t),.25f+.25f*cos(t*.2f),.25f-.25f*sin(t),1.f);
        glClearColor(fogcolor.r,fogcolor.g,fogcolor.b,fogcolor.a);
        glClear(GL_COLOR_BUFFER_BIT);
        handles.shader->uniform_block<FogData>("fog") = FogData({0.01f,fogcolor});
        handles.shader->upload_uniform("fog");
        handles.shader->use();

        handles.geo->draw();

        glUseProgram(0);
#else
        static float old_proj[16];
        glGetFloatv(GL_PROJECTION_MATRIX,old_proj);
        glMatrixMode(GL_PROJECTION);
        glm::mat4 cmat = camera();
        glLoadMatrixf(&cmat[0][0]);
        // I could use OGL's built-in fog here, but frankly, I can't be bothered to.

        handles.geo->draw();

        glMatrixMode(GL_PROJECTION);
        glLoadMatrixf(old_proj);

#endif

        glDisable(GL_DEPTH_TEST);
        glDisable(GL_CULL_FACE);
}
glm::mat4 camera() {
    float t = SDL_GetTicks()/1000.f;
#ifdef GLM_FORCE_RADIANS
    static const glm::mat4 Projection = glm::perspective((float)M_PI/4.f, 4.0f / 3.0f, 0.1f, 100.0f);
#else
    static const glm::mat4 Projection = glm::perspective(45.f, 4.0f / 3.0f, 0.1f, 100.0f);
#endif
    glm::mat4 View = glm::lookAt(glm::vec3(12.f*sin(t/2.f),12.f*cos(t/5.f),2.25f),glm::vec3(0,0,1),glm::vec3(0,0,1));
    static const glm::mat4 Model = glm::mat4(1.0f);
    return Projection * View * Model;
}
