#version 330 core

layout(location = 0) in vec4 vertexPosition;
layout(location = 1) in vec3 vertexTexCoord;
layout(location = 2) in vec3 vertexNormal;

uniform mat4 MVP;
uniform mat4 MV;

out vec3 fragTexCoord;
out vec3 fragNormal;

out vec3 eyePos;

void main(){
    //vec4 v = vec4(vertexPosition,1);
    gl_Position = MVP * vertexPosition;
    fragTexCoord = vertexTexCoord;
	fragNormal = (MV * vec4(vertexNormal,0.f)).xyz;
	eyePos = (MV * vertexPosition).xyz;
}
