#version 330 core

in vec3 fragTexCoord;
in vec3 fragNormal;

in vec3 eyePos;

out vec4 fragColor;

uniform vec4 light_dir = vec4(0.f, 1.f, 1.f, 0.f);
uniform vec4 light_color = vec4(1.f, 1.f, 1.f, 1.f);
uniform vec4 ambient_color = vec4(0.f, 0.f, 0.f, 1.f);

uniform vec4 Ka = vec4(1.f, 1.f, 1.f, 1.f);
uniform vec4 Kd = vec4(1.f, 1.f, 1.f, 1.f);
uniform vec4 Ks = vec4(0.f, 0.f, 0.f, 1.f);
uniform float Ns = 0.f;
uniform int illum = 1;
uniform sampler2D map_Ka, map_Kd, map_Ks, map_Ns, map_Tr, map_bump, map_disp, map_decal;

void main() {
	vec3 nf_norm = normalize(normalize(fragNormal)+texture(map_bump,fragTexCoord.xy).xyz);
	vec3 n_light = normalize(light_dir.xyz);
	float cosTheta = clamp(dot(nf_norm,n_light),0.f,1.f);
	fragColor = Kd*texture(map_Kd,fragTexCoord.xy)*vec4(light_color.rgb*cosTheta,1.f);
	if (illum>0) fragColor += Ka*texture(map_Ka,fragTexCoord.xy)*vec4(ambient_color.rgb,0.f);
	if (illum>1) {
		float cosAlpha = clamp(dot(reflect(normalize(eyePos),nf_norm),n_light),0.f,1.f);
		fragColor.rgb += Ks.rgb*texture(map_Ks,fragTexCoord.xy).rgb*texture(map_Ns,fragTexCoord.xy).r*light_color.rgb*pow(cosAlpha,Ns);
	}
	fragColor=clamp(fragColor,0.f,1.f);
}
