#ifndef SCENE_H
#define SCENE_H

#ifdef _WIN32
#define GLM_FORCE_RADIANS
#define USE_SHADER
#endif

#define SDW_OPENGL
#include "glow_wavefront.hpp"
#include "geometry.h"
#include "sdw.hpp"

#include <glm/gtc/matrix_transform.hpp>
#include <glm/gtx/transform.hpp>

class Scene {
public:
    Scene() {
        camera = glm::vec3(0,-4,2);
        make_terrain();
#ifdef USE_SHADER
        load_shader();
#endif
#ifdef GLM_FORCE_RADIANS
        Projection = glm::perspective((float)M_PI/4.f, 4.0f / 3.0f, 0.1f, 100.0f);
#else
        Projection = glm::perspective(45.f, 4.0f / 3.0f, 0.1f, 100.0f);
#endif
    };

    void run(sdw::GL_Window &win, sdw::Renderer &ren);

    void update(int steps) {}; // in ms

    void draw();

    void make_terrain();
    void load_shader();
    glm::mat4 set_camera();

    glm::mat4 Projection;

    glm::vec3 camera;
    std::shared_ptr<glow::Geometry<VertexC,GLint,TSTRIP>> terrain;
    std::shared_ptr<glow::Shader> shader,mdl_shader;
    glow::Object mdl;
};

#endif // SCENE_H
