#version 330 core

in vec4 fragmentColor;

out vec4 color;

uniform fog {
	float density;
	vec4 fcol;
};

void main() {
	float z = gl_FragCoord.z / gl_FragCoord.w;
	float vis = exp(-density * z * z);
	vis = clamp(vis, 0.0, 1.0);
	color = mix(fcol, fragmentColor, vis);
}
