#include "qdw.hpp"
#include <iostream>

int main(int argc, char **argv)
try { // Yup, that's legal C++

    // Initialize some SDL stuff
    sdw::Context c(SDL_INIT_EVERYTHING,IMG_INIT_ALL,true);

    sdw::Window win("SDL-Test",100,100,640,480);
    sdw::Renderer ren(win,-1,SDL_RENDERER_ACCELERATED); // I don't want vsync here (to test performance limits)

    sdw::Texture img(ren,"image.png");
    sdw::Font arial18("arial.ttf",18);
    sdw::Font buxton64("buxton.ttf",64);
    sdw::Texture text = buxton64.write(ren,"I'm a TTF font!");

    // And make a Gui with a bunch of widgets
    qdw::Theme win_theme(sdw::Surface("tileset_windows.png"),sdw::Font("arial.ttf",12),16,2);
    qdw::TexGui main_gui(ren,win_theme,win.rect());
    main_gui.addLabel("lbl_title",sdw::Rect(100,290,250,80),"I'm a label!");
    qdw::Theme large_text(buxton64,sdw::Color(0,128,255));
    main_gui.get("lbl_title")->custom_theme = &large_text;
    main_gui.addFrame("frm_large",sdw::Rect(25,25,450,200),0);
    main_gui.get("frm_large")->addScrollFrame("frm_ul",sdw::Rect(25,25,200,150),-2);

    main_gui.addSubWindow("win_test",sdw::Rect(100,100,320,200),"I'm a Window!");
    auto &swin = *main_gui.get<qdw::SubWindow>("win_test");
    swin.state|=qdw::Widget::ST_RESIZABLE;
    swin.set_button_states(true,true,false);

    main_gui.addSubWindow("win_two",sdw::Rect(250,250,200,175),"Yet another Window!");
    auto &swin2 = *main_gui.get<qdw::SubWindow>("win_two");
    swin2.set_button_states(false,false,true);

    auto &frm = *main_gui.get<qdw::ScrollFrame>("frm_ul");
    frm.state |= qdw::Widget::ST_RESIZABLE;
    frm.bars = qdw::ScrollFrame::HBAR_AUTO|qdw::ScrollFrame::VBAR_AUTO|
               qdw::ScrollFrame::RBTN_AUTO|qdw::ScrollFrame::SBTN_AUTO;
    frm.addCheckBox("chk1",sdw::Rect(25,100,120,20),"Check this!");
    frm.addCheckBox("chk2",sdw::Rect(25,120,120,20),"Or this!");
    frm.addCheckBox("chk3",sdw::Rect(25,140,120,20),"Or maybe this!");

    frm.addOptionButton("opt1a",sdw::Rect(150,100,120,20),"One option.");
    frm.addOptionButton("opt2a",sdw::Rect(150,120,120,20),"Another option.");
    frm.addOptionButton("opt3a",sdw::Rect(150,140,120,20),"So many options.");

    frm.addOptionButton("opt1b",sdw::Rect(150,200,120,20),"Different block.",1);
    frm.addOptionButton("opt2b",sdw::Rect(150,220,120,20),"With more options.",1);
    frm.addOptionButton("opt3b",sdw::Rect(150,240,120,20),"Three, exactly.",1);

    frm.addEditBox("ed1",sdw::Rect(25,180,120,24));
    auto &ed1 = *main_gui.get<qdw::EditBox>("ed1");
    ed1.text="Edit me!";
    ed1.textEdit = [](qdw::Widget*w,const SDL_Event&){std::cout<<"My text is now: "<<static_cast<qdw::EditBox*>(w)->text<<std::endl;};

    swin.addTextBox("txt_test",sdw::Rect(0,0,260,175));
    auto &txtbox = *main_gui.get<qdw::TextBox>("txt_test");
    txtbox.bars = qdw::ScrollFrame::HBAR_AUTO|qdw::ScrollFrame::VBAR_AUTO|qdw::ScrollFrame::RBTN_AUTO|qdw::ScrollFrame::SBTN_NEVER;
    txtbox.state|=qdw::Widget::ST_RESIZABLE;
    //txtbox.h_align=.5f;
    //txtbox.v_align=1.f;
    txtbox.text = "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";
    qdw::Theme tbox_theme(sdw::Font("buxton.ttf",14),sdw::Color(0,0,128));
    txtbox.custom_theme = &tbox_theme;
    txtbox.readonly=true;
    //txtbox.wraplines=false;

    frm.addIcon("ico_test",sdw::Rect(200,100,32,32),sdw::Surface("icon.png"),"Drag me!");
    auto &ico = *main_gui.get<qdw::Icon>("ico_test");
    ico.make_surfaces();
    ico.caption_pos=qdw::Icon::CP_UNDER;
    ico.mouseDragStart = [](qdw::Widget*,const SDL_Event&){std::cout<<"Hey! Put me down!\n";};
    ico.mouseDragStop = [](qdw::Widget*,const SDL_Event&){std::cout<<"Thanks!\n";};
    ico.mouseDrop = [&](qdw::Widget *a,qdw::Widget *p,const SDL_Event&){std::cout<<"I was dropped on '"<<main_gui.get_id(p)<<"'"<<std::endl;};


    frm.addButton("btn1",sdw::Rect(25,25,120,32),"Click me!",
                     [](qdw::Widget*,const SDL_Event&)
                     {std::cout<<"I was clicked."<<std::endl;} );
    frm.addButton("btn2",sdw::Rect(25,60,120,32),"I'm sticky!",
                     [&](qdw::Widget* w,const SDL_Event&)
                     {std::cout<<"Button state: "<<w->checked()<<std::endl; if (w->checked()) swin.disable(); else swin.enable();} );

    frm.addButton("btn3",sdw::Rect(25,225,120,32),"Find me!",
                     [](qdw::Widget*,const SDL_Event&)
                     {std::cout<<"You got me!"<<std::endl;} );

    auto &btn1 = *main_gui.get<qdw::Button>("btn1");
    auto &btn2 = *main_gui.get<qdw::Button>("btn2");

    btn2.sticky = true;

    qdw::Theme button_theme(sdw::Font("arial.ttf",18),sdw::Color(128,0,0));
    btn1.custom_theme = &button_theme;
    btn1.setHotkey('a',KMOD_CTRL,[](qdw::Widget*,const SDL_Event&){std::cout<<"Hotkey CTRL+A"<<std::endl;} );
    btn2.setHotkey('b',KMOD_SHIFT,[](qdw::Widget*,const SDL_Event&){std::cout<<"Hotkey SHIFT+B"<<std::endl;} );

    //Get the texture w/h so we can center it in the screen
    int x = (win.width()-text.width()) / 2;
    int y = (win.height()-text.height()) / 2;

    int lastframe = SDL_GetTicks();
    int updated_frm = 0;
    int total_frm = 0;
    std::stringstream temp;

    //Our event structure
    SDL_Event e;
    bool quit = false;
    while (!quit) {
        while (SDL_PollEvent(&e)){
            if (!main_gui.hit(e)) {
                if (e.type == SDL_QUIT)
                    quit = true;
                if (e.type == SDL_KEYDOWN){
                    switch (e.key.keysym.sym){
                        case SDLK_ESCAPE:
                            quit = true;
                            break;
                        default:
                            break;
                    }
                }
            }
        }

        // Update Widgets (if necessary)
        if (main_gui.update()) updated_frm++;
        total_frm++;

        // Performance indicators
        int t = SDL_GetTicks();
        temp.str(""); temp.clear();
        temp<<t-lastframe<<" ms/frm";
        sdw::Surface tpf = arial18.write_solid(temp.str());
        temp.str(""); temp.clear();
        temp<<updated_frm<<"/"<<total_frm<<" upd";
        sdw::Surface upd = arial18.write_solid(temp.str());
        lastframe = t;

        // Render with TexGui
        ren.clear();
        img.render(sdw::Point(100,175));
        text.render(sdw::Point(x,y));
        main_gui.render();
        sdw::Texture ttpf(ren,tpf);
        ttpf.render(sdw::Point(win.width()-tpf.width()-5,5));
        sdw::Texture tupd(ren,upd);
        tupd.render(sdw::Point(win.width()-upd.width()-5,25));
        ren.flip();

        // Blit Gui directly
        /*win.fill(128,0,0);
        main_gui.draw((SDL_Surface*)win);
        tpf.blit(win,sdw::Point(win.width()-tpf.width()-5,5));
        upd.blit(win,sdw::Point(win.width()-upd.width()-5,25));
        win.flip();*/


    }

    return 0;

} catch(sdw::Error e) {
    std::cerr<<"Error: "<<e<<std::endl;
    return 0;
} catch (...) {
    std::cerr<<"Unknown exception!"<<std::endl;
    return -1;
}
